const cameraUri = "api/Cameras";
const configUri = "api/Config";
const scheduleUri = "api/Schedule";
const eventUri = "api/Event";

let cameras = [];
let schedules = {};
let locale = ""

async function getItems() {
    document.getElementById("styleSheet").href = "css\\" + localStorage.getItem("theme") + ".css";
    await setLocaleStrings();
    await fetch(configUri, { method: "GET" })
        .then(response => response.json())
        .then(data => {
            if (data.destinationServerName !== null) {
                fetch("languages/" + locale + ".json")
                    .then(response => response.json())
                    .then(jsonResponse => {
                        document.getElementById("SelectedDestination").innerHTML = jsonResponse.SelectedDestinationSelectedServer + data.destinationServerName;
                    });
            }
            if (data.backupEnabled) {
                document.getElementById("backupEnabled").setAttribute("checked", true);
            }
        })
        .catch(error => console.error("Unable to get items.", error));
    updateRunningState();
    fetch(cameraUri + "/selectAll")
        .then(response => response.json())
        .then(data => {
            if (data) {
                document.getElementById("selectAllCameras").setAttribute("checked", true);
            }
        });
    fetch(cameraUri + "/updateDatabase", { method: "GET" })
        .then(response => response.json())
        .then(data => {
            _displayItems(data);
            disableComponents();
        })
        .catch(error => console.error("Unable to get items.", error));

    document.getElementById("configFile")
        .addEventListener("change", readSingleFile, false);

    populateSchedules();
}

async function updateRunningState() {
    fetch(eventUri + "/runningState", { method: "GET" })
        .then(response => response.json())
        .then(data => {
            if (data[0].eventName === "BackupIsRunning") {
                fetch('languages/' + locale + '.json')
                    .then(response => response.json())
                    .then(jsonResponse => {
                        document.getElementById("IsRunning").innerHTML = jsonResponse.InProgress.replace("{0}", data[0].progress ?? "");
                    });
                document.getElementById("syncNow").disabled = true;
            } else {
                if (document.getElementById("backupEnabled").checked) {
                    fetch('languages/' + locale + '.json')
                        .then(response => response.json())
                        .then(jsonResponse => {
                            document.getElementById("IsRunning").innerHTML = jsonResponse.IdleNextRunAt.replace("{0}", data[0].creationTime).replace("{1}", data[0].lastSynced);
                        });
                } else {
                    fetch('languages/' + locale + '.json')
                        .then(response => response.json())
                        .then(jsonResponse => {
                            document.getElementById("IsRunning").innerHTML = jsonResponse.Idle.replace("{0}", data[0].lastSynced);
                        });
                }
                var currentDestinationStatus = "";
                fetch('languages/' + locale + '.json')
                    .then(response => response.json())
                    .then(jsonResponse => {
                        currentDestinationStatus = jsonResponse.SelectedDestinationNoServer;
                        var camerasList = [...document.getElementById("cameras").getElementsByTagName("input")];
                        if (camerasList.filter(camera => camera.checked).length > 0 &&
                            document.getElementById("SelectedDestination").innerHTML !== currentDestinationStatus) {
                            document.getElementById("syncNow").disabled = false;
                        } else {
                            document.getElementById("syncNow").disabled = true;
                        }
                    });
            }
        });
}

function populateSchedules() {
    fetch(scheduleUri + "/getSchedules")
        .then(response => response.json())
        .then(data => {
            schedules = data;
            document.getElementById("scheduleSelect").innerHTML = "<option value=\"Never schedule\">---</option>";
            document.getElementById("weekSchedule").style.marginBottom = (schedules.schedules.length + 2) * 2 + "px";
            for (var schedule in schedules.schedules) {
                var option = document.createElement("option");
                option.value = schedules.schedules[schedule].name;
                option.innerHTML = schedules.schedules[schedule].name;
                if (schedules.schedules[schedule].selected) {
                    option.setAttribute("selected", true);
                }
                document.getElementById("scheduleSelect").appendChild(option);
            }
        });
}

function overrideStartTime() {
    document.getElementById("syncNow").disabled = true;
    fetch(eventUri + "/InitiateNow", { method: "POST" })
        .then(() => {
            updateRunningState();
            document.getElementById("syncNow").disabled = false;
        }).catch(() => {
            document.getElementById("syncNow").disabled = false;
        });
}

function disableComponents() {
    var checkbox = document.getElementById("backupEnabled");

    var currentDestinationStatus = "";
    fetch('languages/' + locale + '.json')
        .then(response => response.json())
        .then(jsonResponse => {
            currentDestinationStatus = jsonResponse.SelectedDestinationNoServer;
        });
    var camerasList = [...document.getElementById("cameras").getElementsByTagName("input")];
    if (camerasList.filter(camera => camera.checked).length > 0 &&
        document.getElementById("SelectedDestination").innerHTML === currentDestinationStatus) {
        document.getElementById("syncNow").disabled = false;
    } else {
        document.getElementById("syncNow").disabled = true;
    }

    if (camerasList.filter(camera => camera.checked).length == 0)
    {
        document.getElementById("scheduleSelect").disabled = true;
        console.log("Skip update any handling.");
        return;
    }

    document.getElementById("scheduleSelect").disabled = !checkbox.checked;
    fetch(configUri + "/BackupEnabled/" + checkbox.checked, { method: "PUT" });
    updateRunningState();
}

function filter() {
    var filterText = document.getElementById("filter").value;
    var cameraItems = [].concat([].slice.call(document.getElementsByClassName("row-layer")),
        [].slice.call(document.getElementsByClassName("hidden")));
    for (var item in cameraItems) {
        var cameraText = cameraItems[item].innerText.toLowerCase();
        if (cameraItems[item].id !== "camera") {
            continue;
        }
        if (!cameraText.includes(filterText.toLowerCase())) {
            cameraItems[item].setAttribute("class", "hidden");
        } else {
            cameraItems[item].setAttribute("class", "row-layer");
        }
    }
}

function clearFilter() {
    document.getElementById("filter").value = "";
    filter();
}

async function longPollingEvents() {
    var info;
    await fetch(eventUri + "/LongPollingEvents", { method: "GET" })
        .then(response => response.json())
        .then(data => {
            info = data.events;
            console.log("event: ", info)
        })
        .catch(error => {
            console.error("Could not get long polling", error);
        });
    if (typeof info !== "undefined") {
        if (info.length > 0) {
            if (info.filter(event => event.eventName === "DeviceChangedEvent").length > 0) {
                fetch(cameraUri + "/updateDatabase", { method: "GET" })
                    .then(response => response.json())
                    .then(data => {
                        _displayItems(data);
                        disableComponents();
                    })
                    .catch(error => console.error("Unable to get items.", error));
            }
            if (info.filter(event => event.eventName === "ScheduleChangedEvent").length > 0) {
                populateSchedules();
            }
            if (info.filter(event => event.eventName === "BackupIsRunning").length > 0) {
                fetch('languages/' + locale + '.json')
                    .then(response => response.json())
                  .then(jsonResponse => {
                    const event = info.filter(event => event.eventName === "BackupIsRunning");
                    document.getElementById("IsRunning").innerHTML = jsonResponse.InProgress.replace("{0}", event[0].progress ?? "");
                  });
                document.getElementById("syncNow").disabled = true;
            }
            if (info.filter(event => event.eventName === "BackupIsNotRunning").length > 0) {
                if (document.getElementById("backupEnabled").checked) {
                    fetch('languages/' + locale + '.json')
                        .then(response => response.json())
                        .then(jsonResponse => {
                            const event = info.filter(event => event.eventName === "BackupIsNotRunning");
                            document.getElementById("IsRunning").innerHTML = jsonResponse.IdleNextRunAt.replace("{0}", event[0].creationTime).replace("{1}", event[0].lastSynced);
                        });
                } else {
                    fetch('languages/' + locale + '.json')
                        .then(response => response.json())
                        .then(jsonResponse => {
                            const event = info.filter(event => event.eventName === "BackupIsNotRunning");
                            document.getElementById("IsRunning").innerHTML = jsonResponse.Idle.replace("{0}", event[0].lastSynced);
                        });
                }
                fetch('languages/' + locale + '.json')
                    .then(response => response.json())
                    .then(jsonResponse => {
                        currentDestinationStatus = jsonResponse.SelectedDestinationNoServer;
                        var camerasList = [...document.getElementById("cameras").getElementsByTagName("input")];
                        if (camerasList.filter(camera => camera.checked).length > 0 &&
                            document.getElementById("SelectedDestination").innerHTML !== currentDestinationStatus) {
                            document.getElementById("syncNow").disabled = false;
                        } else {
                            document.getElementById("syncNow").disabled = true;
                        }
                    });
            }
        }
    }
    await longPollingEvents();
}

function updateWeeklyBackupSchedule() {
    for (var schedule in schedules.schedules) {
        if (schedules.schedules[schedule].name === document.getElementById("scheduleSelect").value) {
            fetch(scheduleUri + "/updateWeekSchedule",
                {
                    method: "PUT",
                    headers: { 'Content-Type': "application/json" },
                    body: JSON.stringify(
                        schedules.schedules[schedule]
                    )
                });
        }
    }
}

function readSingleFile(e) {
    var file = e.target.files[0];
    if (!file) {
        return;
    }
    var reader = new FileReader();
    reader.onload = function (e) {
        var contents = e.target.result;
        document.getElementById("loader").setAttribute("class", "loader");
        document.getElementById("syncNow").disabled = true;
        fetch(configUri + "/configFile", { method: "POST", body: contents, headers: { 'Content-Type': "application/json" } })
            .then(configFileResponse => {
                document.getElementById("loader").removeAttribute("class");
                document.getElementById("filePath").innerHTML = file.name;
                fetch("languages/" + locale + ".json")
                    .then(response => response.json())
                    .then(jsonResponse => {
                        if (configFileResponse.status === 200) {
                            document.getElementById("SelectedDestination").innerHTML =
                                jsonResponse.SelectedDestinationSelectedServer + JSON.parse(contents).SiteName;
                        } else {
                            document.getElementById("syncNow").disabled = false;

                            // Will display previous working server if it fails.
                            document.getElementById("SelectedDestination").innerHTML =
                                jsonResponse.SelectedDestinationSelectedServer + data.destinationServerName;

                        }
                        disableComponents();
                    });
            });
    };
    reader.readAsText(file);
}

function cameraSelectionChanged(cb) {
        fetch(cameraUri + "/" + cb.name + "/" + cb.checked, { method: "PUT" })
            .then(_ => {
                fetch(cameraUri + "/selectAll", { method: "GET" })
                    .then(response => response.json())
                    .then(data => {
                        if (data) {
                            document.getElementById("selectAllCameras").checked = true;
                        } else {
                            document.getElementById("selectAllCameras").checked = false;
                        }
                        disableComponents();
                    });
            });
}

function _displayItems(data) {
    const tBody = document.getElementById("cameras");
    tBody.innerHTML = "";

    data.forEach(item => {
        var cameraLine = document.createElement("LABEL");
        cameraLine.setAttribute("class", "listboxItem");
        var checkBoxContainer = document.createElement("label");
        checkBoxContainer.setAttribute("class", "listCheckboxContainer");
        var input = document.createElement("Input");
        input.setAttribute("class", "checkbox");
        input.setAttribute("onclick", "cameraSelectionChanged(this)");
        input.setAttribute("name", item.id);
        if (item.selected) {
            input.setAttribute("checked", item.selected);
        }
        input.setAttribute("type", "checkbox");
        var customCheckmark = document.createElement("span");
        customCheckmark.setAttribute("class", "customCheckmark");
        checkBoxContainer.appendChild(input);
        checkBoxContainer.appendChild(customCheckmark);
        cameraLine.innerHTML = item.name;
        cameraLine.setAttribute("class", "row-layer");
        cameraLine.setAttribute("id", "camera");
        cameraLine.appendChild(checkBoxContainer);
        tBody.appendChild(cameraLine);
    });

    cameras = data;
}

function selectAllCameras() {
    var checkbox = document.getElementById("selectAllCameras");
    var item = document.getElementById("cameras").getElementsByTagName("input");
    var i;
    if (checkbox.checked) {
        fetch(cameraUri + "/selectAll/true", { method: "PUT" });
        for (i = 0; i < item.length; i++) {
            item[i].checked = true;
        }
    } else {
        fetch(cameraUri + "/selectAll/false", { method: "PUT" });
        for (i = 0; i < item.length; i++) {
            item[i].checked = false;
        }
    }

    disableComponents();
}

function setLocaleStrings() {
    locale = localStorage.getItem("language");
    fetch('languages/' + locale + '.json')
        .then(response => response.json())
        .then(jsonResponse => {
            document.getElementById("Title").innerHTML = jsonResponse.Title;
            document.getElementById("PluginDescription").innerHTML = jsonResponse.PluginDescription;
            document.getElementById("syncNow").value = jsonResponse.SyncNow;
            document.getElementById("filter").placeholder = jsonResponse.Filter;
            document.getElementById("CamerasHeader").innerHTML = jsonResponse.CamerasHeader;
            document.getElementById("NameCategory").innerHTML = jsonResponse.NameCategory;
            document.getElementById("DestinationHeader").innerHTML = jsonResponse.DestinationHeader;
            document.getElementById("DestinationDescription").innerHTML = jsonResponse.DestinationDescription;
            document.getElementById("Browse").innerHTML = jsonResponse.Browse;
            document.getElementById("SelectedDestination").innerHTML = jsonResponse.SelectedDestinationNoServer;
            document.getElementById("ScheduledBackupHeader").innerHTML = jsonResponse.ScheduledBackupHeader;
            document.getElementById("ScheduledBackupDescription").innerHTML = jsonResponse.ScheduledBackupDescription;
            document.getElementById("EnableScheduledBackup").innerHTML = jsonResponse.EnableScheduledBackup;
        });
}
// SIG // Begin signature block
// SIG // MIIoGQYJKoZIhvcNAQcCoIIoCjCCKAYCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // uPJIChgslxDIejlYlrKPqdurCt8WgTaeMl0sW4xcZHeg
// SIG // gg2OMIIGsDCCBJigAwIBAgIQCK1AsmDSnEyfXs2pvZOu
// SIG // 2TANBgkqhkiG9w0BAQwFADBiMQswCQYDVQQGEwJVUzEV
// SIG // MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
// SIG // d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2Vy
// SIG // dCBUcnVzdGVkIFJvb3QgRzQwHhcNMjEwNDI5MDAwMDAw
// SIG // WhcNMzYwNDI4MjM1OTU5WjBpMQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
// SIG // OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
// SIG // IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMIICIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA1bQvQtAorXi3
// SIG // XdU5WRuxiEL1M4zrPYGXcMW7xIUmMJ+kjmjYXPXrNCQH
// SIG // 4UtP03hD9BfXHtr50tVnGlJPDqFX/IiZwZHMgQM+TXAk
// SIG // ZLON4gh9NH1MgFcSa0OamfLFOx/y78tHWhOmTLMBICXz
// SIG // ENOLsvsI8IrgnQnAZaf6mIBJNYc9URnokCF4RS6hnyzh
// SIG // GMIazMXuk0lwQjKP+8bqHPNlaJGiTUyCEUhSaN4QvRRX
// SIG // XegYE2XFf7JPhSxIpFaENdb5LpyqABXRN/4aBpTCfMjq
// SIG // GzLmysL0p6MDDnSlrzm2q2AS4+jWufcx4dyt5Big2MEj
// SIG // R0ezoQ9uo6ttmAaDG7dqZy3SvUQakhCBj7A7CdfHmzJa
// SIG // wv9qYFSLScGT7eG0XOBv6yb5jNWy+TgQ5urOkfW+0/tv
// SIG // k2E0XLyTRSiDNipmKF+wc86LJiUGsoPUXPYVGUztYuBe
// SIG // M/Lo6OwKp7ADK5GyNnm+960IHnWmZcy740hQ83eRGv7b
// SIG // UKJGyGFYmPV8AhY8gyitOYbs1LcNU9D4R+Z1MI3sMJN2
// SIG // FKZbS110YU0/EpF23r9Yy3IQKUHw1cVtJnZoEUETWJrc
// SIG // JisB9IlNWdt4z4FKPkBHX8mBUHOFECMhWWCKZFTBzCEa
// SIG // 6DgZfGYczXg4RTCZT/9jT0y7qg0IU0F8WD1Hs/q27Iwy
// SIG // CQLMbDwMVhECAwEAAaOCAVkwggFVMBIGA1UdEwEB/wQI
// SIG // MAYBAf8CAQAwHQYDVR0OBBYEFGg34Ou2O/hfEYb7/mF7
// SIG // CIhl9E5CMB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/n
// SIG // upiuHA9PMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzB3BggrBgEFBQcBAQRrMGkwJAYIKwYB
// SIG // BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBB
// SIG // BggrBgEFBQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNl
// SIG // cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQw
// SIG // QwYDVR0fBDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGln
// SIG // aWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5j
// SIG // cmwwHAYDVR0gBBUwEzAHBgVngQwBAzAIBgZngQwBBAEw
// SIG // DQYJKoZIhvcNAQEMBQADggIBADojRD2NCHbuj7w6mdNW
// SIG // 4AIapfhINPMstuZ0ZveUcrEAyq9sMCcTEp6QRJ9L/Z6j
// SIG // fCbVN7w6XUhtldU/SfQnuxaBRVD9nL22heB2fjdxyyL3
// SIG // WqqQz/WTauPrINHVUHmImoqKwba9oUgYftzYgBoRGRjN
// SIG // YZmBVvbJ43bnxOQbX0P4PpT/djk9ntSZz0rdKOtfJqGV
// SIG // WEjVGv7XJz/9kNF2ht0csGBc8w2o7uCJob054ThO2m67
// SIG // Np375SFTWsPK6Wrxoj7bQ7gzyE84FJKZ9d3OVG3ZXQIU
// SIG // H0AzfAPilbLCIXVzUstG2MQ0HKKlS43Nb3Y3LIU/Gs4m
// SIG // 6Ri+kAewQ3+ViCCCcPDMyu/9KTVcH4k4Vfc3iosJocsL
// SIG // 6TEa/y4ZXDlx4b6cpwoG1iZnt5LmTl/eeqxJzy6kdJKt
// SIG // 2zyknIYf48FWGysj/4+16oh7cGvmoLr9Oj9FpsToFpFS
// SIG // i0HASIRLlk2rREDjjfAVKM7t8RhWByovEMQMCGQ8M4+u
// SIG // KIw8y4+ICw2/O/TOHnuO77Xry7fwdxPm5yg/rBKupS8i
// SIG // bEH5glwVZsxsDsrFhsP2JjMMB0ug0wcCampAMEhLNKhR
// SIG // ILutG4UI4lkNbcoFUCvqShyepf2gpx8GdOfy1lKQ/a+F
// SIG // SCH5Vzu0nAPthkX0tGFuv2jiJmCG6sivqf6UHedjGzqG
// SIG // VnhOMIIG1jCCBL6gAwIBAgIQCC2MFtJ1dCZDA7Yrcl1L
// SIG // 6DANBgkqhkiG9w0BAQsFADBpMQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
// SIG // OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
// SIG // IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMB4XDTI0MDIx
// SIG // MjAwMDAwMFoXDTI3MDIxMTIzNTk1OVowXjELMAkGA1UE
// SIG // BhMCU0UxDTALBgNVBAcTBEx1bmQxHzAdBgNVBAoTFkF4
// SIG // aXMgQ29tbXVuaWNhdGlvbnMgQUIxHzAdBgNVBAMTFkF4
// SIG // aXMgQ29tbXVuaWNhdGlvbnMgQUIwggGiMA0GCSqGSIb3
// SIG // DQEBAQUAA4IBjwAwggGKAoIBgQDpNEq9tgukB8w6abOq
// SIG // d/puHOB6xilvXY7tfmsLwlqTZ606wscXKguxXsYLd1VU
// SIG // dhnyPoRB65ElfYau7Qk9tDaNbODqhnQfxWrFL6qvIwrq
// SIG // FykEJ3eYKhYRc/2i/taHK9jb7QrMbjYoQVAN4rIhX9Ed
// SIG // Ll3BCKIvrVIstLyX+WbLaKTBLkkjmZQDYXVr8AU3fAy9
// SIG // RAWA6eGf7dZFi2sejSPH4ptTCcYuTmlVHdYWhUDG83gY
// SIG // sA15TFSQsmHElR+37igkYaHpuKV9YH3WzN8n4YoHoCT0
// SIG // botd2ouiOvV+9RqMkQgZ5AoJK8PJ1Kzhxo603vdLFy71
// SIG // UlNGLo91Wc3A5HcTderRxtkitzU/+3eRJoK1EsGm70t+
// SIG // rE0ctFXkgpqKeAcg5U1ApYxoj3Azub4osgxfUkWymtAU
// SIG // rlQAfcbWmqo8PfrFkcYlKh1avHETzspQXM4jjFRUhOBD
// SIG // XGh9wOeTdpG9rQWpUZtBj37wdcEcx3aMPwK3RmAdRWCK
// SIG // wYtiFHFLICsCAwEAAaOCAgMwggH/MB8GA1UdIwQYMBaA
// SIG // FGg34Ou2O/hfEYb7/mF7CIhl9E5CMB0GA1UdDgQWBBQg
// SIG // iE6PNVEUmlGohfgMKi6rsP+VHDA+BgNVHSAENzA1MDMG
// SIG // BmeBDAEEATApMCcGCCsGAQUFBwIBFhtodHRwOi8vd3d3
// SIG // LmRpZ2ljZXJ0LmNvbS9DUFMwDgYDVR0PAQH/BAQDAgeA
// SIG // MBMGA1UdJQQMMAoGCCsGAQUFBwMDMIG1BgNVHR8Ega0w
// SIG // gaowU6BRoE+GTWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNv
// SIG // bS9EaWdpQ2VydFRydXN0ZWRHNENvZGVTaWduaW5nUlNB
// SIG // NDA5NlNIQTM4NDIwMjFDQTEuY3JsMFOgUaBPhk1odHRw
// SIG // Oi8vY3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVz
// SIG // dGVkRzRDb2RlU2lnbmluZ1JTQTQwOTZTSEEzODQyMDIx
// SIG // Q0ExLmNybDCBlAYIKwYBBQUHAQEEgYcwgYQwJAYIKwYB
// SIG // BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBc
// SIG // BggrBgEFBQcwAoZQaHR0cDovL2NhY2VydHMuZGlnaWNl
// SIG // cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZEc0Q29kZVNpZ25p
// SIG // bmdSU0E0MDk2U0hBMzg0MjAyMUNBMS5jcnQwCQYDVR0T
// SIG // BAIwADANBgkqhkiG9w0BAQsFAAOCAgEAU5f66f9RDAuk
// SIG // V7jcGZmPEDUKc0jjgzpi2xVNYTJR6v4oqVjvrbAJx3we
// SIG // Ap2Za24JFWuuLMnJA9vYFjK2KdjzHU8LC/7x5lCNJWY9
// SIG // aSd8wrweRPuApypIWEiK3tcrpDMs2x0ecuV9m0OpFbUd
// SIG // JpCqg060/r5ummwTJjXFcHPo+SCfb4h7KZ3ALF/7e4J2
// SIG // A5jJxwlk0MEdNcDWMqRG5qX+WbRfNt9yObaMvsdkxgce
// SIG // z06HbmM8VohfRh3dfFDRrsjY7Cz5xyNHGN7xjTKORomo
// SIG // rEfXvwh2FKtePTHbkUYn8/ZJKvCQPNZNI/gxLGW/JTjk
// SIG // aAO4LXtNO8Z3rL9+Ti+Hs234Y5CmCAho0VUgf17vGIR9
// SIG // OF7OgGxVgQaKovfwx/UVd0tCx/ic8TSHg1MPC1u1TWK0
// SIG // jh1rkaj0ms5rVpZfjEFA1dKeCyFDJRI6FDbEQb7A2EjI
// SIG // mUkzYszIMqeN+1w79ufojvBjLYipcprDj7imACxVZ9Ey
// SIG // cXSHrSA9B512uetAtxcrBA8bBm1QiOi9ZfY+UQpphdal
// SIG // LO6NqHM75Q8qZXrANLDTkpaSRcck4L5V15aMSQh+2Gs/
// SIG // 9iLb4XzLdQmYTLcqd/GNclpYDKkk65SVcQHFxzl87v5h
// SIG // DGjbw06hf8xp1ubaHShRy9PdoUKpvvMRjToy9AvBvgcm
// SIG // drc0od8tUe4xghnjMIIZ3wIBATB9MGkxCzAJBgNVBAYT
// SIG // AlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjFBMD8G
// SIG // A1UEAxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNp
// SIG // Z25pbmcgUlNBNDA5NiBTSEEzODQgMjAyMSBDQTECEAgt
// SIG // jBbSdXQmQwO2K3JdS+gwDQYJYIZIAWUDBAIBBQCgfDAQ
// SIG // BgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMxDAYK
// SIG // KwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYKKwYB
// SIG // BAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgYqRWoIdoK1V4
// SIG // FScGc6E94VpfX/PpFXPQHKfTSvmkieIwDQYJKoZIhvcN
// SIG // AQEBBQAEggGAzFTioCKbg3LTTxpmebBFkUhuYNB9u/LX
// SIG // X0+LBn/ARuwfxAdSTzsX0pr4RFI5TjGoH0953FCUcWla
// SIG // asWfarpWsM76K495NBzN54t/F5/Orq2VShZG4/YUgUti
// SIG // 1OGhCBaAhfWE+3W/HoRMKOoH0+bAM/Kjx9UJ7T9mZ+vF
// SIG // +lTFWeSw4fws070JWhyGPGMM/7e+aKY2YwZ3Z3AO80p8
// SIG // HtIcDtjyjrYACfIKXowId5q71RnvSyQePocLyi+Kw4Vu
// SIG // 36YIx5OVhTZc6roDZ1L2lSOhl5mCaCI2y2teOMfm7Npf
// SIG // 3mDZUFGWExbqsHYHycWru9K5e50IiWMmKEfeZi7bPf6X
// SIG // Vtk2CNojUSwh6D8Izo+t1cDOj7ZhQ33fgiEPI/lFFW5q
// SIG // KUb/1PFEqacBrnYlHarnjeR0HKewKylWdDmXlg1RYstt
// SIG // u5Jer1qFS0kVG60Tgse5vw0p3pgXPnRrmTABR6K/LjcJ
// SIG // Vg8jp/VIQbM5U13eoHowUrWEv62fi1zLnGzVuewGoYIX
// SIG // OTCCFzUGCisGAQQBgjcDAwExghclMIIXIQYJKoZIhvcN
// SIG // AQcCoIIXEjCCFw4CAQMxDzANBglghkgBZQMEAgEFADB3
// SIG // BgsqhkiG9w0BCRABBKBoBGYwZAIBAQYJYIZIAYb9bAcB
// SIG // MDEwDQYJYIZIAWUDBAIBBQAEIBm/1UO0ac2k/8AyCfU7
// SIG // 6t7N5p7PlpQytgyvfL14qyZEAhAQgiq6Rkv7FapWtdY2
// SIG // YVLiGA8yMDI0MTIxMDExMDY1OVqgghMDMIIGvDCCBKSg
// SIG // AwIBAgIQC65mvFq6f5WHxvnpBOMzBDANBgkqhkiG9w0B
// SIG // AQsFADBjMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGln
// SIG // aUNlcnQsIEluYy4xOzA5BgNVBAMTMkRpZ2lDZXJ0IFRy
// SIG // dXN0ZWQgRzQgUlNBNDA5NiBTSEEyNTYgVGltZVN0YW1w
// SIG // aW5nIENBMB4XDTI0MDkyNjAwMDAwMFoXDTM1MTEyNTIz
// SIG // NTk1OVowQjELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
// SIG // Z2lDZXJ0MSAwHgYDVQQDExdEaWdpQ2VydCBUaW1lc3Rh
// SIG // bXAgMjAyNDCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCC
// SIG // AgoCggIBAL5qc5/2lSGrljC6W23mWaO16P2RHxjEiDtq
// SIG // meOlwf0KMCBDEr4IxHRGd7+L660x5XltSVhhK64zi9Ce
// SIG // C9B6lUdXM0s71EOcRe8+CEJp+3R2O8oo76EO7o5tLusl
// SIG // xdr9Qq82aKcpA9O//X6QE+AcaU/byaCagLD/GLoUb35S
// SIG // fWHh43rOH3bpLEx7pZ7avVnpUVmPvkxT8c2a2yC0WMp8
// SIG // hMu60tZR0ChaV76Nhnj37DEYTX9ReNZ8hIOYe4jl7/r4
// SIG // 19CvEYVIrH6sN00yx49boUuumF9i2T8UuKGn9966fR5X
// SIG // 6kgXj3o5WHhHVO+NBikDO0mlUh902wS/Eeh8F/UFaRp1
// SIG // z5SnROHwSJ+QQRZ1fisD8UTVDSupWJNstVkiqLq+ISTd
// SIG // EjJKGjVfIcsgA4l9cbk8Smlzddh4EfvFrpVNnes4c16J
// SIG // idj5XiPVdsn5n10jxmGpxoMc6iPkoaDhi6JjHd5ibfdp
// SIG // 5uzIXp4P0wXkgNs+CO/CacBqU0R4k+8h6gYldp4FCMgr
// SIG // XdKWfM4N0u25OEAuEa3JyidxW48jwBqIJqImd93NRxvd
// SIG // 1aepSeNeREXAu2xUDEW8aqzFQDYmr9ZONuc2MhTMizch
// SIG // NULpUEoA6Vva7b1XCB+1rxvbKmLqfY/M/SdV6mwWTyeV
// SIG // y5Z/JkvMFpnQy5wR14GJcv6dQ4aEKOX5AgMBAAGjggGL
// SIG // MIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIw
// SIG // ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAE
// SIG // GTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwHwYDVR0j
// SIG // BBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0O
// SIG // BBYEFJ9XLAN3DigVkGalY17uT5IfdqBbMFoGA1UdHwRT
// SIG // MFEwT6BNoEuGSWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNv
// SIG // bS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZU
// SIG // aW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGD
// SIG // MIGAMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdp
// SIG // Y2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9jYWNl
// SIG // cnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRH
// SIG // NFJTQTQwOTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQw
// SIG // DQYJKoZIhvcNAQELBQADggIBAD2tHh92mVvjOIQSR9lD
// SIG // kfYR25tOCB3RKE/P09x7gUsmXqt40ouRl3lj+8QioVYq
// SIG // 3igpwrPvBmZdrlWBb0HvqT00nFSXgmUrDKNSQqGTdpjH
// SIG // sPy+LaalTW0qVjvUBhcHzBMutB6HzeledbDCzFzUy34V
// SIG // arPnvIWrqVogK0qM8gJhh/+qDEAIdO/KkYesLyTVOoJ4
// SIG // eTq7gj9UFAL1UruJKlTnCVaM2UeUUW/8z3fvjxhN6hdT
// SIG // 98Vr2FYlCS7Mbb4Hv5swO+aAXxWUm3WpByXtgVQxiBlT
// SIG // VYzqfLDbe9PpBKDBfk+rabTFDZXoUke7zPgtd7/fvWTl
// SIG // Cs30VAGEsshJmLbJ6ZbQ/xll/HjO9JbNVekBv2Tgem+m
// SIG // LptR7yIrpaidRJXrI+UzB6vAlk/8a1u7cIqV0yef4uaZ
// SIG // FORNekUgQHTqddmsPCEIYQP7xGxZBIhdmm4bhYsVA6G2
// SIG // WgNFYagLDBzpmk9104WQzYuVNsxyoVLObhx3RugaEGru
// SIG // +SojW4dHPoWrUhftNpFC5H7QEY7MhKRyrBe7ucykW7ea
// SIG // CuWBsBb4HOKRFVDcrZgdwaSIqMDiCLg4D+TPVgKx2EgE
// SIG // deoHNHT9l3ZDBD+XgbF+23/zBjeCtxz+dL/9NWR6P2eZ
// SIG // Ri7zcEO1xwcdcqJsyz/JceENc2Sg8h3KeFUCS7tpFk7C
// SIG // rDqkMIIGrjCCBJagAwIBAgIQBzY3tyRUfNhHrP0oZipe
// SIG // WzANBgkqhkiG9w0BAQsFADBiMQswCQYDVQQGEwJVUzEV
// SIG // MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
// SIG // d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2Vy
// SIG // dCBUcnVzdGVkIFJvb3QgRzQwHhcNMjIwMzIzMDAwMDAw
// SIG // WhcNMzcwMzIyMjM1OTU5WjBjMQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNVBAMT
// SIG // MkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBTSEEy
// SIG // NTYgVGltZVN0YW1waW5nIENBMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAxoY1BkmzwT1ySVFVxyUD
// SIG // xPKRN6mXUaHW0oPRnkyibaCwzIP5WvYRoUQVQl+kiPNo
// SIG // +n3znIkLf50fng8zH1ATCyZzlm34V6gCff1DtITaEfFz
// SIG // sbPuK4CEiiIY3+vaPcQXf6sZKz5C3GeO6lE98NZW1Oco
// SIG // LevTsbV15x8GZY2UKdPZ7Gnf2ZCHRgB720RBidx8ald6
// SIG // 8Dd5n12sy+iEZLRS8nZH92GDGd1ftFQLIWhuNyG7QKxf
// SIG // st5Kfc71ORJn7w6lY2zkpsUdzTYNXNXmG6jBZHRAp8By
// SIG // xbpOH7G1WE15/tePc5OsLDnipUjW8LAxE6lXKZYnLvWH
// SIG // po9OdhVVJnCYJn+gGkcgQ+NDY4B7dW4nJZCYOjgRs/b2
// SIG // nuY7W+yB3iIU2YIqx5K/oN7jPqJz+ucfWmyU8lKVEStY
// SIG // dEAoq3NDzt9KoRxrOMUp88qqlnNCaJ+2RrOdOqPVA+C/
// SIG // 8KI8ykLcGEh/FDTP0kyr75s9/g64ZCr6dSgkQe1CvwWc
// SIG // ZklSUPRR8zZJTYsg0ixXNXkrqPNFYLwjjVj33GHek/45
// SIG // wPmyMKVM1+mYSlg+0wOI/rOP015LdhJRk8mMDDtbiiKo
// SIG // wSYI+RQQEgN9XyO7ZONj4KbhPvbCdLI/Hgl27KtdRnXi
// SIG // YKNYCQEoAA6EVO7O6V3IXjASvUaetdN2udIOa5kM0jO0
// SIG // zbECAwEAAaOCAV0wggFZMBIGA1UdEwEB/wQIMAYBAf8C
// SIG // AQAwHQYDVR0OBBYEFLoW2W1NhS9zKXaaL3WMaiCPnshv
// SIG // MB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/nupiuHA9P
// SIG // MA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggrBgEF
// SIG // BQcDCDB3BggrBgEFBQcBAQRrMGkwJAYIKwYBBQUHMAGG
// SIG // GGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBBBggrBgEF
// SIG // BQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29t
// SIG // L0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQwQwYDVR0f
// SIG // BDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGlnaWNlcnQu
// SIG // Y29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcmwwIAYD
// SIG // VR0gBBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcBMA0G
// SIG // CSqGSIb3DQEBCwUAA4ICAQB9WY7Ak7ZvmKlEIgF+ZtbY
// SIG // IULhsBguEE0TzzBTzr8Y+8dQXeJLKftwig2qKWn8acHP
// SIG // HQfpPmDI2AvlXFvXbYf6hCAlNDFnzbYSlm/EUExiHQwI
// SIG // gqgWvalWzxVzjQEiJc6VaT9Hd/tydBTX/6tPiix6q4XN
// SIG // Q1/tYLaqT5Fmniye4Iqs5f2MvGQmh2ySvZ180HAKfO+o
// SIG // vHVPulr3qRCyXen/KFSJ8NWKcXZl2szwcqMj+sAngkSu
// SIG // mScbqyQeJsG33irr9p6xeZmBo1aGqwpFyd/EjaDnmPv7
// SIG // pp1yr8THwcFqcdnGE4AJxLafzYeHJLtPo0m5d2aR8XKc
// SIG // 6UsCUqc3fpNTrDsdCEkPlM05et3/JWOZJyw9P2un8WbD
// SIG // Qc1PtkCbISFA0LcTJM3cHXg65J6t5TRxktcma+Q4c6um
// SIG // AU+9Pzt4rUyt+8SVe+0KXzM5h0F4ejjpnOHdI/0dKNPH
// SIG // +ejxmF/7K9h+8kaddSweJywm228Vex4Ziza4k9Tm8heZ
// SIG // Wcpw8De/mADfIBZPJ/tgZxahZrrdVcA6KYawmKAr7ZVB
// SIG // tzrVFZgxtGIJDwq9gdkT/r+k0fNX2bwE+oLeMt8EifAA
// SIG // zV3C+dAjfwAL5HYCJtnwZXZCpimHCUcr5n8apIUP/JiW
// SIG // 9lVUKx+A+sDyDivl1vupL0QVSucTDh3bNzgaoSv27dZ8
// SIG // /DCCBY0wggR1oAMCAQICEA6bGI750C3n79tQ4ghAGFow
// SIG // DQYJKoZIhvcNAQEMBQAwZTELMAkGA1UEBhMCVVMxFTAT
// SIG // BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
// SIG // LmRpZ2ljZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQg
// SIG // QXNzdXJlZCBJRCBSb290IENBMB4XDTIyMDgwMTAwMDAw
// SIG // MFoXDTMxMTEwOTIzNTk1OVowYjELMAkGA1UEBhMCVVMx
// SIG // FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQ
// SIG // d3d3LmRpZ2ljZXJ0LmNvbTEhMB8GA1UEAxMYRGlnaUNl
// SIG // cnQgVHJ1c3RlZCBSb290IEc0MIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAv+aQc2jeu+RdSjwwIjBp
// SIG // M+zCpyUuySE98orYWcLhKac9WKt2ms2uexuEDcQwH/Mb
// SIG // pDgW61bGl20dq7J58soR0uRf1gU8Ug9SH8aeFaV+vp+p
// SIG // VxZZVXKvaJNwwrK6dZlqczKU0RBEEC7fgvMHhOZ0O21x
// SIG // 4i0MG+4g1ckgHWMpLc7sXk7Ik/ghYZs06wXGXuxbGrzr
// SIG // yc/NrDRAX7F6Zu53yEioZldXn1RYjgwrt0+nMNlW7sp7
// SIG // XeOtyU9e5TXnMcvak17cjo+A2raRmECQecN4x7axxLVq
// SIG // GDgDEI3Y1DekLgV9iPWCPhCRcKtVgkEy19sEcypukQF8
// SIG // IUzUvK4bA3VdeGbZOjFEmjNAvwjXWkmkwuapoGfdpCe8
// SIG // oU85tRFYF/ckXEaPZPfBaYh2mHY9WV1CdoeJl2l6SPDg
// SIG // ohIbZpp0yt5LHucOY67m1O+SkjqePdwA5EUlibaaRBkr
// SIG // fsCUtNJhbesz2cXfSwQAzH0clcOP9yGyshG3u3/y1Yxw
// SIG // LEFgqrFjGESVGnZifvaAsPvoZKYz0YkH4b235kOkGLim
// SIG // dwHhD5QMIR2yVCkliWzlDlJRR3S+Jqy2QXXeeqxfjT/J
// SIG // vNNBERJb5RBQ6zHFynIWIgnffEx1P2PsIV/EIFFrb7Gr
// SIG // hotPwtZFX50g/KEexcCPorF+CiaZ9eRpL5gdLfXZqbId
// SIG // 5RsCAwEAAaOCATowggE2MA8GA1UdEwEB/wQFMAMBAf8w
// SIG // HQYDVR0OBBYEFOzX44LScV1kTN8uZz/nupiuHA9PMB8G
// SIG // A1UdIwQYMBaAFEXroq/0ksuCMS1Ri6enIZ3zbcgPMA4G
// SIG // A1UdDwEB/wQEAwIBhjB5BggrBgEFBQcBAQRtMGswJAYI
// SIG // KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNv
// SIG // bTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGln
// SIG // aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENB
// SIG // LmNydDBFBgNVHR8EPjA8MDqgOKA2hjRodHRwOi8vY3Js
// SIG // My5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURS
// SIG // b290Q0EuY3JsMBEGA1UdIAQKMAgwBgYEVR0gADANBgkq
// SIG // hkiG9w0BAQwFAAOCAQEAcKC/Q1xV5zhfoKN0Gz22Ftf3
// SIG // v1cHvZqsoYcs7IVeqRq7IviHGmlUIu2kiHdtvRoU9BNK
// SIG // ei8ttzjv9P+Aufih9/Jy3iS8UgPITtAq3votVs/59Pes
// SIG // MHqai7Je1M/RQ0SbQyHrlnKhSLSZy51PpwYDE3cnRNTn
// SIG // f+hZqPC/Lwum6fI0POz3A8eHqNJMQBk1RmppVLC4oVaO
// SIG // 7KTVPeix3P0c2PR3WlxUjG/voVA9/HYJaISfb8rbII01
// SIG // YBwCA8sgsKxYoA5AY8WYIsGyWfVVa88nq2x2zm8jLfR+
// SIG // cWojayL/ErhULSd+2DrZ8LaHlv1b0VysGMNNn3O3Aamf
// SIG // V6peKOK5lDGCA3YwggNyAgEBMHcwYzELMAkGA1UEBhMC
// SIG // VVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYD
// SIG // VQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYg
// SIG // U0hBMjU2IFRpbWVTdGFtcGluZyBDQQIQC65mvFq6f5WH
// SIG // xvnpBOMzBDANBglghkgBZQMEAgEFAKCB0TAaBgkqhkiG
// SIG // 9w0BCQMxDQYLKoZIhvcNAQkQAQQwHAYJKoZIhvcNAQkF
// SIG // MQ8XDTI0MTIxMDExMDY1OVowKwYLKoZIhvcNAQkQAgwx
// SIG // HDAaMBgwFgQU29OF7mLb0j575PZxSFCHJNWGW0UwLwYJ
// SIG // KoZIhvcNAQkEMSIEII7eBpfCWkTw5c17qjsiQCHqID38
// SIG // wHeEB+uy/KrYEaI9MDcGCyqGSIb3DQEJEAIvMSgwJjAk
// SIG // MCIEIHZ2n6jyYy8fQws6IzCu1lZ1/tdz2wXWZbkFk5hD
// SIG // j5rbMA0GCSqGSIb3DQEBAQUABIICALJmj7OAGqnYKkyW
// SIG // cvTm4owyXQGj8qnYa3kBDaqV1wru8T5umgm39xNbgrzg
// SIG // EANbdeKWOiA5j3rmTuKzgsjWEegy+0ZDucbGgyMd89d/
// SIG // yEuFjSR7tCvrE3tAwOOwzVi/L+HqIdik8wDxn8Cc2yWf
// SIG // bvCEl9dzbNyiMlReEuwzq2/emsbEsH33jGJpf6GSps4S
// SIG // aWsacqhIGuVtsW8c55a9/HAfbO1DlAJAFmfMoBA+ib4j
// SIG // F12YymjC68IwwYzmZp/Nc3OL8ZUVT6A1uwiz2I0AKlhk
// SIG // mlIwPdkVvqrTsqaa22igC0XxCmY/CcAYrTuq197Ut8eN
// SIG // fxdqmT+pIPsJt9X+YPCqvz0euwf/84BXkWToNvBeNm+A
// SIG // gYRDM/bWROVN/uN7xQcERnmfX0MCTu2jUllCMl042fpd
// SIG // tU4b11FWPHq29EvAmAoq91m/K+/fxBnagFMhhLHT0K9Y
// SIG // f7qN5PgjaR8zrNJJhrfK/RZE7rx7DIN+O0Kx9zUq/dmA
// SIG // IGtx0lcV5raeNTfxb70qD6Ys0Acyvjr3M5hYq/T0iFO6
// SIG // 1yX5Y6BAmE4/VW954hq+ULD3kXtmtSOfZ4xQ9bBI7++Z
// SIG // 48VdAwU/23sDfq3m6LX6uHB3ZjErg5Hj+M9ZCdqmqNzb
// SIG // 6x7MEgN2/rZBKkwLwZdqwb77tBKLB1dcq6gjUwKN0zV6
// SIG // oup3M5iw
// SIG // End signature block
